package DeathByCaptcha::Client;

use strict;
use warnings;

use constant API_VERSION => "DBC/Perl v4.5.0";
use constant SOFTWARE_VENDOR_ID => 0;

use constant DEFAULT_TIMEOUT => 60;
use constant POLLS_INTERVAL => (1, 1, 2, 3, 2, 2, 3, 2, 2);
use constant LEN_POLLS_INTVL => scalar(POLLS_INTERVAL);
use constant DFLT_POLL_INTERVAL => 3;


sub loadImage
{
    my $fn = shift;
    open (FILE, "<$fn") or die "Failed opening $fn ($!)";
    my $buff;
    my $img = '';
    while ($buff = <FILE>) {
        $img .= $buff;
    }
    close(FILE);
    return $img;
}

sub connect
{
    return 1;
}

sub close
{
    return 1;
}

sub getBalance
{
    my $self = shift;
    if (defined (my $user = $self->getUser())) {
        if (0 < $user->{"user"}) {
            return $user->{"balance"};
        }
    }
    return undef;
}

sub getText
{
    my $self = shift;
    if (defined (my $captcha = $self->getCaptcha(shift))) {
        if (0 < $captcha->{"captcha"} and "" ne $captcha->{"text"}) {
            return $captcha->{"text"};
        }
    }
    return undef;
}

sub decode
{
    my $self = shift;
    my $fn = shift;
    my $timeout = shift;
    my $deadline = time + ((defined $timeout and 0 < $timeout)
        ? $timeout
        : +DEFAULT_TIMEOUT);
    my $idx = 0;
    my $intvl = 0;

    if (defined (my $captcha = $self->upload($fn))) {
        while ($deadline > time and not defined $captcha->{"text"}) {
            ($intvl, $idx) = get_poll_interval($idx);
            sleep ($intvl);
            $captcha = $self->getCaptcha($captcha->{"captcha"});
        }
        if (defined $captcha->{"text"}) {
            if ($captcha->{"is_correct"}) {
                return $captcha;
            }
        }
    }
    return undef;
}

sub get_poll_interval
{
  my $idx = shift;
  my $intvl = 0;

  if (LEN_POLLS_INTVL > $idx) {
    $intvl = (POLLS_INTERVAL)[$idx];
  }
  else {
    $intvl = DFLT_POLL_INTERVAL;
  }
  $idx++;

  return ($intvl, $idx);
}

1;
